/*
 * Decompiled with CFR 0.152.
 */
package com.cottagesystems.jdiskhog;

import com.cottagesystems.jdiskhog.DiskUsageModel;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.autoplot.datasource.AutoplotSettings;
import org.das2.util.LoggerManager;

public class FSTreeModel
implements TreeModel {
    DecimalFormat nf = new DecimalFormat();
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.jdiskhog");
    DiskUsageModel model;
    File root;
    Map<File, File[]> listings = new HashMap<File, File[]>();
    Comparator comparator;
    public boolean hideListingFile = false;
    public Comparator fileSizeComparator = new Comparator(){

        public String toString() {
            return "fileSize";
        }

        public int compare(Object o1, Object o2) {
            Long l;
            File f1 = (File)o1;
            File f2 = (File)o2;
            if (f1 == null || f2 == null) {
                return -1;
            }
            long s1 = f1.isFile() ? f1.length() / 1000L : ((l = FSTreeModel.this.model.usage(f1)) == null ? 0L : l);
            long s2 = f2.isFile() ? f2.length() / 1000L : ((l = FSTreeModel.this.model.usage(f2)) == null ? 0L : l);
            if (f1.isFile() && f2.isFile()) {
                String key1 = ((File)o1).getName();
                String key2 = ((File)o2).getName();
                return key1.compareTo(key2);
            }
            if (f1.isDirectory() && f2.isDirectory()) {
                return s1 < s2 ? 1 : -1;
            }
            return f1.isDirectory() ? -1 : 1;
        }
    };
    public static final Comparator alphaComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            if (f1 == null || f2 == null) {
                return -1;
            }
            String key1 = ((File)o1).getName();
            String key2 = ((File)o2).getName();
            return key1.compareTo(key2);
        }

        public String toString() {
            return "alpha";
        }
    };
    ArrayList<TreeModelListener> listeners = new ArrayList();

    public FSTreeModel(DiskUsageModel model, File root) {
        String sort;
        this.model = model;
        this.root = root;
        Preferences prefs = AutoplotSettings.settings().getPreferences(FSTreeModel.class);
        switch (sort = prefs.get("fsTreeSort", "size")) {
            case "size": {
                this.comparator = this.fileSizeComparator;
                break;
            }
            case "alpha": {
                this.comparator = alphaComparator;
                break;
            }
            default: {
                System.err.println("bad fsTreeSort value: " + sort);
                this.comparator = this.fileSizeComparator;
            }
        }
    }

    public void setComparator(Comparator c) {
        logger.log(Level.FINE, "set comparator to {0}", c);
        Comparator old = this.comparator;
        this.comparator = c;
        if (old != c) {
            Preferences prefs = AutoplotSettings.settings().getPreferences(FSTreeModel.class);
            prefs.put("fsTreeSort", c == this.fileSizeComparator ? "size" : "alpha");
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            System.err.println("reset comparator to " + c);
            this.listings = new HashMap<File, File[]>();
            this.fireTreeStructureChanged();
        }
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    protected void fireTreeStructureChanged() {
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.root});
        for (TreeModelListener tml : this.listeners) {
            tml.treeStructureChanged(e);
        }
    }

    public boolean isHideListingFile() {
        return this.hideListingFile;
    }

    public void setHideListingFile(boolean hideListingFile) {
        this.hideListingFile = hideListingFile;
    }

    @Override
    public Object getRoot() {
        return new TreeNode(this.root, null, true);
    }

    @Override
    public Object getChild(Object parent, int index) {
        File[] ffs;
        File fparent = ((TreeNode)parent).getFile();
        File[] ff = this.listings.get(fparent);
        File ff1 = ff[index];
        while (ff1.isDirectory() && (ffs = ff1.listFiles()) != null && ffs.length == 1 && ffs[0].isDirectory()) {
            ff1 = ffs[0];
        }
        return new TreeNode(ff1, fparent);
    }

    @Override
    public int getChildCount(Object parent) {
        File f = ((TreeNode)parent).getFile();
        if (!f.exists()) {
            return 0;
        }
        if (f.isFile()) {
            return 0;
        }
        File[] ff = this.listings.get(f);
        if (ff == null) {
            ff = f.listFiles();
            assert (ff != null);
            if (this.hideListingFile) {
                ArrayList<File> lff = new ArrayList<File>(Arrays.asList(ff));
                lff.remove(new File(f, ".listing"));
                ff = lff.toArray(new File[lff.size()]);
            }
            if (this.comparator != null) {
                logger.log(Level.FINER, "sorting by comparator: {0}", this.comparator);
                Arrays.sort(ff, this.comparator);
            }
            this.listings.put(f, ff);
        }
        return ff.length;
    }

    @Override
    public boolean isLeaf(Object node) {
        File f = ((TreeNode)node).getFile();
        return f.isFile();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public File getFile(TreePath context) {
        Object node = context.getPathComponent(context.getPathCount() - 1);
        return ((TreeNode)node).getFile();
    }

    private boolean isParentOf(File parent, File child) {
        try {
            return child.getCanonicalPath().startsWith(parent.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        File f = ((TreeNode)parent).getFile();
        File fchild = ((TreeNode)child).getFile();
        File[] ff = this.listings.get(f);
        for (int i = 0; i < ff.length; ++i) {
            if (!ff[i].equals(fchild) && !this.isParentOf(ff[i], fchild)) continue;
            return i;
        }
        throw new IllegalArgumentException("bad child");
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    class TreeNode {
        File parentFile;
        File f;
        boolean abs;
        boolean windows = true;

        TreeNode(File f) {
            this(f, null);
        }

        TreeNode(File f, File parentFile) {
            this(f, parentFile, false);
        }

        TreeNode(File f, File parentFile, boolean abs) {
            this.f = f;
            this.parentFile = parentFile;
            this.abs = abs;
            this.windows = System.getProperty("os.name").toLowerCase(Locale.US).startsWith("win");
        }

        public File getFile() {
            return this.f;
        }

        private String fromWindows(String s) {
            if (this.windows) {
                return s.replace('\\', '/');
            }
            return s;
        }

        private String getName() {
            if (this.abs) {
                return this.fromWindows(this.f.toString());
            }
            if (this.parentFile == null) {
                return this.fromWindows(this.f.getName());
            }
            return this.fromWindows(this.f.toString().substring(this.parentFile.toString().length() + 1));
        }

        public String toString() {
            if (this.f.isFile()) {
                return this.getName() + " " + FSTreeModel.this.nf.format((double)this.f.length() / 1000000.0) + " MB";
            }
            if (this.f.exists()) {
                Long usages = FSTreeModel.this.model.usage(this.f);
                if (usages == null) {
                    return this.getName() + "                    ";
                }
                return this.getName() + " " + FSTreeModel.this.nf.format((double)FSTreeModel.this.model.usage(this.f).longValue() / 1000.0) + " MB";
            }
            return this.getName() + " 0 MB";
        }
    }
}

